/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioArrival;
import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioArrivalPattern;
import filenet.sim.api.VWScenarioArrivalRecurrence;
import filenet.sim.api.VWScenarioArrivalType;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioDurationPattern;
import filenet.sim.api.VWScenarioFieldCollection;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.IFieldCollection;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class VWScenarioWorkflowDefinition
implements Serializable {
    private VWScenarioDefinition m_scenarioDef = null;
    private VWWorkflowDefinition m_workflowDef = null;
    private VWWorkflowDefinition m_generatedWorkflowDef = null;
    private VWScenarioDurationPattern m_durationPattern = null;
    private Map m_arrivals = Collections.synchronizedMap(new HashMap());
    private Map m_arrivalPatterns = Collections.synchronizedMap(new HashMap());
    private Map m_stepSettings = Collections.synchronizedMap(new HashMap());
    private IFieldCollection inheritedFieldCollection = null;
    private static final String DEFAULT_BASE_WORKCLASS_NAME = "WorkObjectEx";
    private static final String CONDUCTOR_QUEUE = "Conductor";

    protected VWScenarioWorkflowDefinition(VWWorkflowDefinition workflowDef, VWScenarioDefinition scenarioDef, VWSession session) throws VWException {
        this.m_scenarioDef = scenarioDef;
        this.setWorkflowDefinition(workflowDef, session);
    }

    public VWWorkflowDefinition getWorkflowDefinition() {
        return this.m_workflowDef;
    }

    protected VWWorkflowDefinition getWorkflowDefinition(boolean runtimeGeneration) {
        if (runtimeGeneration && this.m_generatedWorkflowDef != null) {
            return this.m_generatedWorkflowDef;
        }
        return this.m_workflowDef;
    }

    public void setWorkflowDefinition(VWWorkflowDefinition workflowDef, VWSession session) throws VWException {
        boolean bInheritsProperties;
        if (workflowDef == null) {
            throw new VWException("sim.api.VWScenarioProcessDefinition.NullWorkflowDefParameter", "The workflowDef parameter can not be null.");
        }
        if (this.m_workflowDef != null && !this.m_workflowDef.getName().equals(workflowDef.getName())) {
            throw new VWException("sim.api.VWScenarioProcessDefinition.InvalidWorkflowDefParameter", "Set workflow definition failed.  The name of the new workflow definition must match the name of the existing workflow definition.");
        }
        boolean bl = bInheritsProperties = !workflowDef.getBaseWorkClassName().equals(DEFAULT_BASE_WORKCLASS_NAME);
        if (bInheritsProperties && session == null) {
            throw new VWException("sim.api.VWScenarioProcessDefinition.VWSessionIsNeededToFlattenWorkflow", "A VWSession must be provided since the workflow definition inherits from base class {0}.", workflowDef.getBaseWorkClassName());
        }
        this.m_workflowDef = session != null ? this.flattenWorkflow(workflowDef, session) : workflowDef;
        this.updateStepSettings();
    }

    public void setWorkflowDefinition(VWWorkflowDefinition workflowDef) throws VWException {
        this.setWorkflowDefinition(workflowDef, null);
    }

    protected void setGeneratedWorkflowDefinition(VWWorkflowDefinition workflowDef) throws VWException {
        this.m_generatedWorkflowDef = workflowDef;
    }

    public VWScenarioArrivalDefinition createArrival(String name, Object startTime, VWScenarioArrivalOccurrence occurrence, VWScenarioArrivalRecurrence recurrence, String[][] fieldAssignments) throws VWException {
        if (this.hasArrival(name)) {
            throw new VWException("sim.api.VWScenarioWorkflowDefinition.ArrivalAlreadyCreated", "An arrival with the name {0} has already been created.", name);
        }
        VWScenarioArrivalDefinition arrivalDef = new VWScenarioArrivalDefinition(name, startTime, occurrence, recurrence, fieldAssignments, this);
        this.m_arrivals.put(name, arrivalDef);
        return arrivalDef;
    }

    public VWScenarioArrivalPattern createArrival(String name, Object startTime, Date acquireStartTime, Object acquireEndTime, float adjustFactor, String dataSource) throws VWException {
        if (this.hasArrival(name)) {
            throw new VWException("sim.api.VWScenarioWorkflowDefinition.ArrivalAlreadyCreated", "An arrival with the name {0} has already been created.", name);
        }
        VWScenarioArrivalPattern arrivalPattern = new VWScenarioArrivalPattern(name, startTime, acquireStartTime, acquireEndTime, adjustFactor, dataSource, this);
        this.m_arrivalPatterns.put(name, arrivalPattern);
        return arrivalPattern;
    }

    public Object createArrival(String name, Object arrival) throws VWException {
        Object clone = null;
        if (this.hasArrival(name)) {
            throw new VWException("sim.api.VWScenarioWorkflowDefinition.ArrivalAlreadyCreated", "An arrival with the name {0} has already been created.", name);
        }
        int type = VWScenarioArrivalType.getArrivalType(arrival);
        if (!VWScenarioArrivalType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioWorkflowDefinition.InvalidArrivalValue", "The value is a {0}, which is not a supported arrival type.", arrival != null ? arrival.getClass().getName() : null);
        }
        switch (type) {
            case 1: {
                clone = ((VWScenarioArrivalDefinition)arrival).clone(name);
                this.m_arrivals.put(name, clone);
                break;
            }
            case 2: {
                clone = ((VWScenarioArrivalPattern)arrival).clone(name);
                this.m_arrivalPatterns.put(name, clone);
            }
        }
        return clone;
    }

    public Object[] getArrivals(int type) {
        Object[] result = null;
        if ((type & 3) == 3) {
            if (this.m_arrivals.size() > 0 || this.m_arrivalPatterns.size() > 0) {
                result = new Object[this.m_arrivals.size() + this.m_arrivalPatterns.size()];
                System.arraycopy(this.m_arrivals.values().toArray(), 0, result, 0, this.m_arrivals.size());
                System.arraycopy(this.m_arrivalPatterns.values().toArray(), 0, result, this.m_arrivals.size(), this.m_arrivalPatterns.size());
            }
        } else if ((type & 1) == 1) {
            if (this.m_arrivals.size() != 0) {
                result = this.m_arrivals.values().toArray(new VWScenarioArrivalDefinition[0]);
            }
        } else if ((type & 2) == 2 && this.m_arrivalPatterns.size() != 0) {
            result = this.m_arrivalPatterns.values().toArray(new VWScenarioArrivalPattern[0]);
        }
        return result;
    }

    public void deleteArrival(String arrivalName) throws VWException {
        if (arrivalName == null) {
            throw new VWException("sim.api.VWScenarioProcessDefinition.NullNameParameter", "The name parameter can not be null.");
        }
        if (this.m_arrivals.containsKey(arrivalName)) {
            this.m_arrivals.remove(arrivalName);
        } else if (this.m_arrivalPatterns.containsKey(arrivalName)) {
            this.m_arrivalPatterns.remove(arrivalName);
        } else {
            throw new VWException("sim.api.VWScenarioProcessDefinition.ArrivalNotFound", "No arrival found with name equal to {0} in the scenario workflow definition.", arrivalName);
        }
    }

    public VWScenarioDurationPattern getDurationPattern() {
        return this.m_durationPattern;
    }

    public void setDurationPattern(VWScenarioDurationPattern durationPattern) {
        this.m_durationPattern = durationPattern;
        if (this.m_durationPattern != null) {
            this.m_durationPattern.setScenarioWorkflow(this);
        }
    }

    public VWScenarioStepSettings getStepSettings(String mapName, int stepId) throws VWException {
        Integer theStepId = new Integer(stepId);
        VWMapDefinition theMapDefinition = this.m_workflowDef.getMap(mapName);
        VWMapNode theMapNode = theMapDefinition.getStep(stepId);
        if (this.m_stepSettings.containsKey(mapName)) {
            Map stepsMap = (Map)this.m_stepSettings.get(mapName);
            if (stepsMap.containsKey(theStepId)) {
                return (VWScenarioStepSettings)stepsMap.get(theStepId);
            }
            VWScenarioStepSettings stepSettings = new VWScenarioStepSettings(this, theMapDefinition, theMapNode);
            stepsMap.put(theStepId, stepSettings);
            return stepSettings;
        }
        Map<Integer, VWScenarioStepSettings> stepsMap = Collections.synchronizedMap(new HashMap());
        this.m_stepSettings.put(mapName, stepsMap);
        VWScenarioStepSettings stepSettings = new VWScenarioStepSettings(this, theMapDefinition, theMapNode);
        stepsMap.put(theStepId, stepSettings);
        return stepSettings;
    }

    public void validate(Vector EDefVector, VWSession theSession, boolean validateWorkflow, VWSystemConfiguration sysConfig, String sdfFileContents) throws VWException {
        int i;
        VWValidationError[] wfErrors;
        this.inheritedFieldCollection = null;
        if (theSession != null) {
            this.inheritedFieldCollection = theSession.fetchWorkflowSignature(this.m_workflowDef.getBaseWorkClassName());
        }
        if (validateWorkflow && (wfErrors = this.m_workflowDef.validate(theSession, sysConfig, sdfFileContents)) != null) {
            for (i = 0; i < wfErrors.length; ++i) {
                EDefVector.addElement(new VWScenarioValidationError(wfErrors[i], this.getWorkflowDefinition().getName()));
            }
        }
        this.validateWorkflowReferences(EDefVector);
        Object[] arrivals = this.getArrivals(3);
        if (arrivals != null) {
            for (i = 0; i < arrivals.length; ++i) {
                ((IVWScenarioArrival)arrivals[i]).validate(EDefVector);
            }
        }
        if (this.m_durationPattern != null) {
            this.m_durationPattern.validate(EDefVector);
        }
        Iterator maps = this.m_stepSettings.values().iterator();
        while (maps.hasNext()) {
            Iterator steps = ((Map)maps.next()).values().iterator();
            while (steps.hasNext()) {
                ((VWScenarioStepSettings)steps.next()).validate(EDefVector);
            }
        }
    }

    private void validateWorkflowReferences(Vector EDefVector) throws VWException {
        VWScenarioRoleDefinition[] roles = this.m_scenarioDef.getRoles();
        VWMapDefinition[] maps = this.m_workflowDef.getMaps();
        for (int i = 0; i < maps.length; ++i) {
            VWMapNode[] steps = maps[i].getSteps();
            for (int j = 0; j < steps.length; ++j) {
                if (steps[j] instanceof VWStepDefinition) {
                    VWStepDefinition stepDef = (VWStepDefinition)steps[j];
                    VWParticipant[] p = stepDef.getParticipants();
                    String queueName = stepDef.getQueueName();
                    if (p != null) {
                        for (int k = 0; k < p.length; ++k) {
                            boolean enclosedByQuotes;
                            String pName = p[k].getParticipantName();
                            boolean bl = enclosedByQuotes = pName.startsWith("\"") && pName.endsWith("\"");
                            if (!enclosedByQuotes) continue;
                            pName = pName.substring(1, pName.length() - 1);
                            this.validateStepParticipant(pName, stepDef.getName(), stepDef.getStepId(), maps[i].getName(), EDefVector);
                        }
                        continue;
                    }
                    if (stepDef == this.m_workflowDef.getLaunchStep() || queueName == null) continue;
                    this.validateWorkQueueStep(stepDef, maps[i].getName(), EDefVector, roles);
                    continue;
                }
                if (!(steps[j] instanceof VWCompoundStepDefinition)) continue;
                this.validateCompoundStep((VWCompoundStepDefinition)steps[j], maps[i].getName(), EDefVector);
            }
        }
    }

    private void validateStepParticipant(String pName, String stepName, int stepId, String mapName, Vector EDefVector) throws VWException {
        if (!this.m_scenarioDef.hasResource(pName)) {
            VWString message = new VWString("sim.api.VWScenarioWorkflowDefinition.ParticipantNotImported", "Step participant needs to be a resource in the scenario.");
            VWScenarioValidationError theError = new VWScenarioValidationError(8, 1, stepName, pName, message.toString(), this.getWorkflowDefinition().getName(), mapName, stepId);
            EDefVector.addElement(theError);
        } else if (!this.m_scenarioDef.getResource(pName).hasResourceAssignments()) {
            VWString message = new VWString("sim.api.VWScenarioWorkflowDefinition.StepParticipantNotAssignedToShift", "Step participant has not been assigned to any shift.");
            VWScenarioValidationError theError = new VWScenarioValidationError(8, 2, stepName, pName, message.toString(), this.getWorkflowDefinition().getName(), mapName, stepId);
            EDefVector.addElement(theError);
        }
    }

    private void validateWorkQueueStep(VWStepDefinition step, String mapName, Vector EDefVector, VWScenarioRoleDefinition[] roles) throws VWException {
        String queueName = step.getQueueName();
        if (queueName.equals(CONDUCTOR_QUEUE)) {
            return;
        }
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                if (!roles[i].hasQueue(queueName) || !roles[i].hasRoleAssignments()) continue;
                VWScenarioRoleAssignment[] rAssignments = roles[i].getRoleAssignments();
                for (int j = 0; j < rAssignments.length; ++j) {
                    if (!rAssignments[j].hasResources()) continue;
                    return;
                }
            }
        }
        VWString message = new VWString("sim.api.VWScenarioWorkflowDefinition.NoResourcesAssignedToWorkOnQueue", "No resources have been assigned to work on queue.");
        VWScenarioValidationError theError = new VWScenarioValidationError(8, 2, step.getName(), queueName, message.toString(queueName), this.getWorkflowDefinition().getName(), mapName, step.getStepId());
        EDefVector.addElement(theError);
    }

    private void validateCompoundStep(VWCompoundStepDefinition step, String mapName, Vector EDefVector) throws VWException {
        VWString sMissingWorkflow = new VWString("sim.api.VWScenarioWorkflowDefinition.WorkflowNotImported", "Workflow ''{0}'' is referenced by a System Step and must be imported into the scenario.");
        VWInstructionDefinition[] instrs = step.getInstructions();
        if (instrs != null) {
            for (int i = 0; i < instrs.length; ++i) {
                String[] params;
                int actionType = instrs[i].getAction();
                if (actionType != 6 || (params = ((VWSimpleInstruction)instrs[i]).getParams()) == null || params.length <= 0 || this.m_scenarioDef.hasWorkflow(params[0])) continue;
                VWScenarioValidationError theError = new VWScenarioValidationError(8, 1, step.getName(), this.getWorkflowDefinition().getName(), sMissingWorkflow.toString(params[0]), this.getWorkflowDefinition().getName(), mapName, step.getStepId());
                EDefVector.addElement(theError);
            }
        }
    }

    protected void updateArrival(String oldName, String newName) throws VWException {
        Object arrival;
        if (this.m_arrivals.containsKey(oldName)) {
            Object arrival2 = this.m_arrivals.remove(oldName);
            if (arrival2 != null) {
                this.m_arrivals.put(newName, arrival2);
            }
        } else if (this.m_arrivalPatterns.containsKey(oldName) && (arrival = this.m_arrivalPatterns.remove(oldName)) != null) {
            this.m_arrivalPatterns.put(newName, arrival);
        }
    }

    protected boolean hasArrival(String name) {
        return this.m_arrivals.containsKey(name) || this.m_arrivalPatterns.containsKey(name);
    }

    protected boolean hasArrivals() {
        return this.m_arrivals.size() > 0 || this.m_arrivalPatterns.size() > 0;
    }

    protected VWScenarioDefinition getScenario() {
        return this.m_scenarioDef;
    }

    protected IFieldCollection getFieldCollection() throws VWException {
        return new VWScenarioFieldCollection(this.getWorkflowDefinition());
    }

    protected IFieldCollection getInheritedFieldCollection() {
        return this.inheritedFieldCollection;
    }

    private void updateStepSettings() {
        VWMapDefinition mapDefinition = null;
        String mapName = null;
        Iterator mapNames = this.m_stepSettings.keySet().iterator();
        while (mapNames.hasNext()) {
            try {
                mapName = (String)mapNames.next();
                mapDefinition = this.m_workflowDef.getMap(mapName);
                Map mapStepSettings = (Map)this.m_stepSettings.get(mapName);
                Iterator stepIds = mapStepSettings.keySet().iterator();
                while (stepIds.hasNext()) {
                    try {
                        Integer stepId = (Integer)stepIds.next();
                        VWMapNode mapNode = mapDefinition.getStep(stepId);
                        VWScenarioStepSettings stepSettings = (VWScenarioStepSettings)mapStepSettings.get(stepId);
                        stepSettings.setMapNode(mapNode);
                    }
                    catch (VWException e) {
                        stepIds.remove();
                    }
                }
            }
            catch (VWException e) {
                mapNames.remove();
            }
        }
    }

    private VWWorkflowDefinition flattenWorkflow(VWWorkflowDefinition workflow, VWSession session) throws VWException {
        VWWorkflowDefinition flattenedWorkflow = workflow.getFlattenedCopy(session);
        flattenedWorkflow.setName(workflow.getName());
        return flattenedWorkflow;
    }
}

